;This is a program is associate with chapter 14 and the TMR1 exercise.  For this program,
;a speaker is attached to PORTC, 5, and a 10K ohm variable resistor is connected to PORTA, 2.
;The TMR1 module increment is created by reading the 8-bits of the ADC value and placing 
;this value in TMR1H.  The TMR0 module is program to provide a 1000Hz tone through the 
;speaker.  Varying the poteniometer will vary the time that the tone is present.



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define TMR0_scale	.14			;TMR0 preload factor, this value gives 1000Hz toggle
;*******************************************************************************

;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	h_byte			;used by ADC routine
	l_byte
	bit_state
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	goto interrupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL
				
	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC
	movlw	b'00000111'	;comparator disconnected and off
	movwf	CMCON
	movlw	b'00000000'	;globals disabled, peripherals disabled,TMR0 disabled,
	movwf	INTCON		;T0IF cleared
	movlw	b'00110000'	;TMR1 prescale 1:8, internal clock, TMR1 stopped
	movwf	T1CON
	bcf		PIR1,TMR1IF	;clear TMR1 interrupt flag
	movlw	b'00001001'	;left justified, Vdd ref, ch 02, clear done, ADC on
	movwf	ADCON0
	BANKSEL	Bank1		; BANK1
	
	movlw	b'00010000'	;Fosc/8
	movwf	ADCON1
	movlw	b'0000000'	;TMR0 set-up:  pull-ups enabled,X,internal clk,X,
						;pre-scale tmr0, pre-scale 1:2 
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00000100'	;RA2 input, all others output 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;all output(could also use clear)
	movwf	TRISC		;program PORTC
	movlw	b'00000100'	;RA2 analog, all others digital
	movwf	ANSEL
	movlw	b'00000001'	;TMR1 interrupt enabled
	movwf	PIE1		
	BANKSEL	Bank0		;back to bank0
	
;*****************************************************************************
;end pic initialization
;*****************************************************************************

;main program


	call	get_adc
	movfw	h_byte			;reload TMR1 high byte
	movwf	TMR1H
	movlw	b'11100000'		;enable TMR0, enable periferrals, enable globals
	movwf	INTCON
	movlw	TMR0_scale		;reset TMR0 scaling
	movwf	TMR0
	bsf		T1CON,TMR1ON	;start TMR1

self goto self		



interrupt_service
	btfss	PIE1,TMR1IF		;check if interrupt was from TMR1
	goto	tone			;if not, must be from TMR0, send tone
	call	get_adc
	movfw	h_byte			;reload TMR1 high byte
	movwf	TMR1H
	btfsc	bit_state,0
	goto	high_bit
low_bit
	bcf		INTCON,T0IE		;turn off tone
	bsf		bit_state,0		;set for next to be high
	bcf		PIR1,TMR1IF		;clear TMR1 interrupt flag
	retfie					;should set GIE
high_bit
	bcf		INTCON,T0IF		;clear TMR0 interrupt
	movlw	TMR0_scale		;reset TMR0 scaling
	movwf	TMR0
	bsf		INTCON,T0IE		;turn on tone
	bcf		bit_state,0		;set for next to be low
	bcf		PIR1,TMR1IF		;clear TMR1 interrupt flag
	retfie


tone
	bcf		INTCON,T0IF		;clear TMR0 interrupt
	movlw	TMR0_scale		;reset TMR0 scaling
	movwf	TMR0
	movlw	b'00100000'		;set up to toggle RC4
	xorwf	PORTC,f		
	retfie

get_adc
	bsf		ADCON0,GO	;set GO bit to begin ADC conversion
wait_ADC
	btfsc	ADCON0,NOT_DONE	;check if ADC complete (cleared bit)
	goto	wait_ADC		;if not, loop and wait until clear
	BANKSEL	Bank1			;switch to bank 1 to access ADC low byte
	movfw	ADRESL
	BANKSEL Bank0			;go back to bank 0 to access l_byte variable
	movwf	l_byte
	movfw	ADRESH
	movwf	h_byte
	return
;*****************************************************************************


	end
